package de.bebagoe.matrain.ml;

import java.util.*;

public class Sets {
	public static <E> Set<E> intersection(Set<? extends E> seta, Set<? extends E> setb) {
		Set<E> setab = new HashSet<E>(seta);
		setab.retainAll(setb);
		return setab;
	}
	
	public static <E> Set<E> union(Set<? extends E> seta, Set<? extends E> setb) {
		Set<E> setab = new HashSet<E>(seta);
		setab.addAll(setb);
		return setab;
	}
	
	public static <E> Set<E> difference(Set<? extends E> seta, Set<? extends E> setb) {
		Set<E> setab = new HashSet<E>(seta);
		setab.removeAll(setb);
		return setab;
	}
}
